/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.jbuilder;

import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.MasterLinkDescriptor;
import borland.jbcl.dataset.ReadWriteRow;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jclass.datasource.ColumnModel;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableModel;
import jclass.datasource.IdeDataTable;
import jclass.datasource.LocaleBundle;
import jclass.datasource.jbuilder.MetaData;
import jclass.datasource.treemodel.TreeNode;

public class DataTable
extends IdeDataTable {
    static final long serialVersionUID = 5508416327638861175L;
    DataSet dataSet;
    DataSetView dataSetView;
    private boolean eventsOriginallyOn;

    public DataTable(MetaData metaData, DataSet dataSet, long l) {
        super(metaData, l);
        this.dataSet = dataSet;
        this.copyTable();
    }

    public DataTable(MetaData metaData, DataSet dataSet) {
        super(metaData);
        this.dataSet = dataSet;
        this.copyTable();
    }

    public synchronized void copyTable() {
        try {
            this.turnOffDataModelEvents();
            int n = this.getIDERows();
            this.dataSet.first();
            int n2 = 0;
            while (n2 < n) {
                DataRow dataRow = new DataRow(this.dataSet);
                this.dataSet.getDataRow(dataRow);
                this.addInternalRow(this.duplicateRow(dataRow));
                this.dataSet.next();
                ++n2;
            }
            this.dataSet.first();
            this.turnOnDataModelEvents();
            return;
        }
        catch (Exception exception) {
            this.turnOnDataModelEvents();
            System.out.println("getRowIdentifier " + exception.toString());
            return;
        }
    }

    public Object[] duplicateRow(int n) throws Exception {
        return new Object[this.metaData.getColumnCount()];
    }

    private Object[] duplicateRow(DataRow dataRow) throws Exception {
        Object[] objectArray = new Object[this.metaData.getColumnCount()];
        int n = 0;
        while (n < this.metaData.getColumnCount()) {
            objectArray[n] = this.getCell(dataRow, this.metaData.getColumnIdentifier(n));
            ++n;
        }
        return objectArray;
    }

    private int getIDERows() {
        try {
            return this.dataSet.getRowCount();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private Object getCell(DataRow dataRow, String string) throws Exception {
        switch (dataRow.getColumn(string).getDataType()) {
            case 10: {
                return dataRow.getBigDecimal(string);
            }
            case 11: {
                return new Boolean(dataRow.getBoolean(string));
            }
            case 13: {
                return dataRow.getDate(string);
            }
            case 7: {
                return new Double(dataRow.getDouble(string));
            }
            case 6: {
                return new Float(dataRow.getFloat(string));
            }
            case 4: {
                return new Integer(dataRow.getInt(string));
            }
            case 16: {
                return dataRow.getString(string);
            }
            case 15: {
                return dataRow.getTimestamp(string);
            }
            case 14: {
                return dataRow.getTime(string);
            }
            case 5: {
                return new Long(dataRow.getLong(string));
            }
            case 3: {
                return new Integer(dataRow.getShort(string));
            }
            case 17: {
                return dataRow.getObject(string);
            }
            case 2: {
                return new Byte(dataRow.getByte(string));
            }
            case 18: {
                return dataRow.getByteArray(string);
            }
            case 12: {
                return ((MetaData)this.metaData).createByteArrayFromBinaryStream(dataRow.getBinaryStream(string));
            }
        }
        return dataRow.getString(string);
    }

    public Object getCell2(long l, String string) throws Exception {
        this.moveToRow(l);
        DataRow dataRow = new DataRow(this.dataSet);
        this.dataSet.getDataRow(dataRow);
        return this.getCell(dataRow, string);
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        DataTable dataTable = null;
        try {
            this.turnOffDataModelEvents();
            MetaData metaData = (MetaData)treeNode;
            this.moveToRow(l);
            dataTable = new DataTable(metaData, metaData.dataSet, l);
            metaData.setCurrentDataTable(dataTable);
            long l2 = -1L;
            if (dataTable.getRowCount() != 0) {
                dataTable.first();
                l2 = dataTable.getCurrentBookmark();
            }
            metaData.setCurrentBookmark(l2);
            this.turnOnDataModelEvents();
            this.getMetaData().getDataModel().moveToRow(dataModelListener, this, l);
        }
        catch (Exception exception) {
            this.turnOnDataModelEvents();
            throw new DataModelException(107, exception);
        }
        return dataTable;
    }

    public void moveToRow(long l) throws Exception {
        this.metaData.setCurrentDataTable(this);
        this.metaData.setCurrentBookmark(l);
        if (this.getRowStatus(l) == 2) {
            return;
        }
        this.turnOffDataModelEvents();
        this.positionDataSet();
        int n = this.store.getIndex(l);
        if (this.dataSet.getRow() != n && !this.dataSet.goToRow(n)) {
            System.out.println("moveToRow() ERROR row " + l);
        }
        this.turnOnDataModelEvents();
    }

    void positionDataSet() throws Exception {
        MasterLinkDescriptor masterLinkDescriptor = this.dataSet.getMasterLink();
        if (masterLinkDescriptor == null) {
            return;
        }
        DataSet dataSet = masterLinkDescriptor.getMasterDataSet();
        DataTable dataTable = (DataTable)this.getParent();
        if (dataSet != null && dataTable != null) {
            dataTable.positionDataSet();
            int n = dataTable.store.getIndex(this.parentRow);
            dataTable.getMetaData().setCurrentDataTable(dataTable);
            dataTable.getMetaData().setCurrentBookmark(this.parentRow);
            if (dataSet.getRow() != n && !dataSet.goToRow(n)) {
                System.out.println("move failed in positionDataSet");
            }
        }
    }

    public long addRow(DataModelListener dataModelListener) throws DataModelException {
        try {
            ColumnModel columnModel = this.metaData.getColumnObject(this.metaData.getColumnIdentifier(0));
            if (columnModel != null && !this.metaData.getInsertAllowed(columnModel.getTableName())) {
                Exception exception = new Exception(LocaleBundle.string("Insert Not Allowed"));
                throw new DataModelException(1, exception);
            }
            this.positionDataSet();
            this.dataSet.insertRow(false);
            return this.bookmarkOfLastRowAdded;
        }
        catch (Exception exception) {
            throw new DataModelException(this.bookmarkOfLastRowAdded, "", this, 101, exception);
        }
    }

    public void deleteRow(DataModelListener dataModelListener, long l) throws DataModelException {
        try {
            ColumnModel columnModel = this.metaData.getColumnObject(this.metaData.getColumnIdentifier(0));
            if (columnModel != null && !this.metaData.getDeleteAllowed(columnModel.getTableName())) {
                Exception exception = new Exception(LocaleBundle.string("Delete Not Allowed"));
                throw new DataModelException(5, exception);
            }
            if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 5))) {
                return;
            }
            this.moveToRow(l);
            this.dataSet.deleteRow();
            this.dataSet.saveChanges();
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(l, "", this, 102, exception);
        }
    }

    public boolean commitRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 10))) {
            return false;
        }
        this.getRowIndex(l);
        if (this.getRowStatus(l) == 4 || this.getRowStatus(l) == 5) {
            return true;
        }
        int n = this.getRowStatus(l);
        Object v = null;
        if (n == 3) {
            v = this.logicallyDeletedRows.get(new Long(l));
        } else if (n == 2) {
            v = this.insertedRows.get(new Long(l));
        }
        try {
            this.removeRowFromLogicallyDeletedTable(l);
            this.removeRowFromInsertedTable(l);
            this.turnOffDataModelEvents();
            this.dataSet.saveChanges();
            this.turnOnDataModelEvents();
            this.commitRow2(l);
        }
        catch (Exception exception) {
            this.turnOnDataModelEvents();
            if (n == 3) {
                this.logicallyDeletedRows.put(new Long(l), v);
            } else if (n == 2) {
                this.insertedRows.put(new Long(l), v);
            }
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
            throw new DataModelException(l, "", this, 10, exception);
        }
        return true;
    }

    public void saveRow(long l) throws Exception {
    }

    public void rollbackTransaction() {
    }

    public void refreshRow(long l) throws Exception {
        this.moveToRow(l);
        DataRow dataRow = new DataRow(this.dataSet);
        this.dataSet.getDataRow(dataRow);
        this.dataSet.refetchRow((ReadWriteRow)dataRow);
        this.dataSet.updateRow(dataRow);
        this.removeRowFromIdeMap(l);
    }

    public void setValueAt(long l, String string, Object object) throws Exception {
        this.requestIDEToUpdateCell(l, string, object);
        super.setValueAt(l, string, object);
    }

    public void cancelRowChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 8))) {
            return;
        }
        try {
            this.moveToRow(l);
            this.dataSet.cancel();
            ((MetaData)this.metaData).cancelling = false;
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    void cancelRowChanges2(long l) throws DataModelException {
        this.removeRowFromIdeMap(l);
        super.cancelRowChanges(this, l);
    }

    private void requestIDEToUpdateCell(long l, String string, Object object) throws Exception {
        if (this.getRowStatus(l) != 2 && this.getMetaData().getCurrentBookmark() != l) {
            this.moveToRow(l);
        }
        this.turnOffDataModelEvents();
        switch (this.dataSet.getColumn(string).getDataType()) {
            case 10: {
                this.dataSet.setBigDecimal(string, (BigDecimal)object);
                break;
            }
            case 11: {
                this.dataSet.setBoolean(string, ((Boolean)object).booleanValue());
                break;
            }
            case 13: {
                this.dataSet.setDate(string, (Date)object);
                break;
            }
            case 7: {
                this.dataSet.setDouble(string, ((Double)object).doubleValue());
                break;
            }
            case 6: {
                this.dataSet.setFloat(string, ((Float)object).floatValue());
                break;
            }
            case 4: {
                this.dataSet.setInt(string, ((Integer)object).intValue());
                break;
            }
            case 16: {
                this.dataSet.setString(string, object.toString());
                break;
            }
            case 15: {
                this.dataSet.setTimestamp(string, (Timestamp)object);
                break;
            }
            case 14: {
                this.dataSet.setTime(string, (Time)object);
                break;
            }
            case 2: {
                this.dataSet.setByte(string, ((Byte)object).byteValue());
                break;
            }
            case 3: {
                this.dataSet.setShort(string, ((Integer)object).shortValue());
                break;
            }
            case 5: {
                this.dataSet.setLong(string, ((Long)object).longValue());
                break;
            }
            case 12: {
                this.dataSet.setBinaryStream(string, (InputStream)new ByteArrayInputStream((byte[])object));
                break;
            }
            case 18: {
                this.dataSet.setByteArray(string, ((String)object).getBytes(), ((String)object).length());
                break;
            }
            case 17: {
                this.dataSet.setObject(string, object);
                break;
            }
            default: {
                System.out.println("updateCell(): Unsupported data type " + this.dataSet.getColumn(string).getDataType());
                this.dataSet.setString(string, object.toString());
            }
        }
        this.turnOnDataModelEvents();
    }

    public DataTableModel requeryLevel() throws Exception {
        this.store.clear();
        this.logicallyDeletedRows.clear();
        this.updatedRows.clear();
        this.insertedRows.clear();
        this.ideRowIndexToBookmarkMap.clear();
        ((MetaData)this.getMetaData()).refreshDataSet();
        this.copyTable();
        ((MetaData)this.getMetaData()).cleanChildDataSets();
        return this;
    }

    private void turnOffDataModelEvents() {
        this.getMetaData().getDataModel().enableDataModelEvents(false);
    }

    private void turnOnDataModelEvents() {
        this.getMetaData().getDataModel().enableDataModelEvents(true);
    }
}

